//Window position set.  It is used to space new windows so that each new untitled document or window 
//doesn't sit directly on top of the last one, and to ensure that windows that are created, whether as 
//new untitled documents, or loaded from a file, are actually visible on-screen.

//Conventions:
//    Global constants (declared with const) and #defines - all uppercase letters with words separated 
//        by underscores.
//        (E.G., #define MY_DEFINE 5).
//        (E.G., const int MY_CONSTANT = 5;).
//    New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//        lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//        associating them with a particular enumerated set.
//        (E.G., typedef int MyTypedef;).
//        (E.G., enum MyEnumConst {MEC_ONE, MEC_TWO};)
//    Global variables - begin with "g_" followed by lowercase words separated by underscores.
//        (E.G., int g_my_global;).
//    Local variables - begin with a lowercase letter followed by lowercase words separated by
//        underscores.
//        (E.G., int my_local;).
//    Argument variables - begin with "a_" followed by lowercase words separated by underscores.
//        (E.G., ...int a_my_argument, ...).
//    Member variables - begin with "m_" followed by lowercase words separated by underscores.
//        (E.G., int m_my_member;).
//    Functions (member or global) - begin with an uppercase letter followed by lowercase words
//        separated by uppercase letters.
//        (E.G., void MyFunction(void);).


//******************************************************************************************************
//**** PROJECT HEADER FILES
//******************************************************************************************************
#include <Screen.h>
#include <Window.h>


//******************************************************************************************************
//**** PROJECT HEADER FILES
//******************************************************************************************************
#include "WindowPositionSet.h"


WindowPositionSet::WindowPositionSet(BRect a_initial_default, bool a_fixed_window_size)
{
	m_initial_default = a_initial_default;
	m_current_default = a_initial_default;
	m_last_origin = a_initial_default;
	m_fixed_window_size = a_fixed_window_size;
	m_min_width = 1.0;
	m_min_height = 1.0;
	m_max_width = 1000000.0;
	m_max_height = 1000000.0;
}


void WindowPositionSet::CheckWindowPosition(BWindow *a_window)
{
	BRect screen_limits = BScreen().Frame();
	screen_limits.InsetBy(3.0,3.0);
	if(!screen_limits.Intersects(a_window->Frame()))
	{
		a_window->Lock();
		a_window->MoveTo(m_initial_default.LeftTop());
		a_window->Unlock();
	}
}


void WindowPositionSet::CheckWindowPosition(BRect *a_rect)
{
	BRect screen_limits = BScreen().Frame();
	screen_limits.InsetBy(3.0,3.0);
	if(!screen_limits.Intersects(*a_rect))
		a_rect->OffsetTo(m_initial_default.LeftTop());
}


void WindowPositionSet::SetSizeLimits(float a_min_width, float a_max_width, float a_min_height, float a_max_height)
{
	m_min_width = a_min_width;
	m_max_width = a_max_width;
	m_min_height = a_min_height;
	m_max_height = a_max_height;

	//Check stored BRects against size limits
	float width = m_initial_default.right-m_initial_default.left;
	float height = m_initial_default.bottom-m_initial_default.top;
	if(width < m_min_width)
		m_initial_default.right = m_initial_default.left + m_min_width;
	if(height < m_min_height)
		m_initial_default.bottom = m_initial_default.top + m_min_height;
	if(width > m_max_width)
		m_initial_default.right = m_initial_default.left + m_max_width;
	if(height > m_max_height)
		m_initial_default.bottom = m_initial_default.top + m_max_height;

	width = m_current_default.right-m_current_default.left;
	height = m_current_default.bottom-m_current_default.top;
	if(width < m_min_width)
		m_current_default.right = m_current_default.left + m_min_width;
	if(height < m_min_height)
		m_current_default.bottom = m_current_default.top + m_min_height;
	if(width > m_max_width)
		m_current_default.right = m_current_default.left + m_max_width;
	if(height > m_max_height)
		m_current_default.bottom = m_current_default.top + m_max_height;

	width = m_last_origin.right-m_last_origin.left;
	height = m_last_origin.bottom-m_last_origin.top;
	if(width < m_min_width)
		m_last_origin.right = m_last_origin.left + m_min_width;
	if(height < m_min_height)
		m_last_origin.bottom = m_last_origin.top + m_min_height;
	if(width > m_max_width)
		m_last_origin.right = m_last_origin.left + m_max_width;
	if(height > m_max_height)
		m_last_origin.bottom = m_last_origin.top + m_max_height;
}

void WindowPositionSet::GetSizeLimits(float* a_min_width, float* a_max_width, float* a_min_height, float* a_max_height)
{
	*a_min_width = m_min_width;
	*a_max_width = m_max_width;
	*a_min_height = m_min_height;
	*a_max_height = m_max_height;
}


BRect WindowPositionSet::GetNextUntitledWindow()
{
	BRect screen_limits = BScreen().Frame();
	screen_limits.InsetBy(8.0,8.0);
	float width,height;
	if(m_fixed_window_size)
	{
		//Window size may not be varied
		if(!screen_limits.Contains(m_current_default))
		{
			m_current_default.OffsetTo(m_last_origin.LeftTop());
			m_current_default.OffsetBy(50.0,0.0);
			m_last_origin = m_current_default;
		}
		if(!screen_limits.Contains(m_current_default))
		{
			m_current_default = m_initial_default;
			m_last_origin = m_initial_default;
		}
	}
	else
	{
		//Window size may vary
		
		width = m_current_default.right-m_current_default.left;
		height = m_current_default.bottom-m_current_default.top;
		if(width < m_min_width)
			m_current_default.right = m_current_default.left+m_min_width;
		if(height < m_min_height)
			m_current_default.bottom = m_current_default.top+m_min_height;
		if(!screen_limits.Contains(m_current_default))
		{
			if(m_current_default.right > screen_limits.right)
				m_current_default.right = screen_limits.right;
			if(m_current_default.bottom > screen_limits.bottom)
				m_current_default.bottom = screen_limits.bottom;
		}
		width = m_current_default.right-m_current_default.left;
		height = m_current_default.bottom-m_current_default.top;
		if(width < m_min_width || height < m_min_height)
		{
			m_current_default = m_last_origin;
			m_current_default.OffsetBy(50.0,0.0);
			m_last_origin = m_current_default;
		}
		width = m_current_default.right-m_current_default.left;
		height = m_current_default.bottom-m_current_default.top;
		if(width < m_min_width || height < m_min_height)
		{
			m_current_default = m_initial_default;
			width = m_current_default.right-m_current_default.left;
			height = m_current_default.bottom-m_current_default.top;
			if(width < m_min_width)
				m_current_default.right = m_current_default.left + m_min_width;
			if(height < m_min_height)
				m_current_default.bottom = m_current_default.top + m_min_height;
			m_last_origin = m_current_default;
		}
	}
	BRect return_rect = m_current_default;
	m_current_default.OffsetBy(25.0,25.0);
	return return_rect;
}


void WindowPositionSet::WindowClosingSetDefault(BWindow *a_window)
{
	m_current_default = a_window->Frame();
}

BRect WindowPositionSet::GetCurrentDefault()
{
	return m_current_default;
}

void WindowPositionSet::SetCurrentDefault(BRect a_rect)
{
	m_current_default = a_rect;
}